<?php
require_once 'includes/authors.php';
require_once 'includes/breadcrumbs.php';
require_once 'includes/bank_block.php';

function renderPage($links, $url, $domainName, $domainZone, $templateDefault, $headContent, $defaultText, $keysMfo) {
    $headLinesCount = count($headContent);
    $linkIndex = array_search($url, array_column($links, 'Page'));

    // 🧩 Получаем авторов
    $authors = getAuthorsByDomain($_SERVER['HTTP_HOST']);
    $author = $authors['author'] ?? '';
    $editor = $authors['editor'] ?? '';
    $contributor = $authors['contributor'] ?? '';
    $replacements = ['%key%', '%author%', '%editor%', '%contributor%'];
    $values = ['', $author, $editor, $contributor];

    if ($linkIndex !== false) {
        $linkInfo = $links[$linkIndex];
        $key = $linkInfo['Key'];
        $values[0] = $key;

        $h1 = str_replace($replacements, $values, $linkInfo['H1']);
        $pageTitle = !empty($linkInfo['Title']) 
            ? str_replace($replacements, $values, $linkInfo['Title']) . " - $domainName"
            : "$h1 - $domainName";

        $templateFileName = !empty($linkInfo['Template']) ? $linkInfo['Template'] : $templateDefault;
        $template = file_exists($templateFileName) ? file_get_contents($templateFileName) : file_get_contents($templateDefault);

        $textRaw = trim($linkInfo['Text']);
        if (preg_match('/^\[(.+\.txt)\]$/', $textRaw, $matches)) {
            $file = 'data/' . $matches[1];
            if (file_exists($file)) {
                $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                $textRaw = $lines[array_rand($lines)];
            } else {
                $textRaw = '[Файл не найден: ' . $matches[1] . ']';
            }
        } elseif ($textRaw === '') {
            $textRaw = $defaultText;
        }

        $textContent = processSpins($textRaw);
        $textContent = str_replace($replacements, $values, $textContent);

        // ✅ ДОБАВЛЕНО: обработка вставок [file.txt]
        $textContent = preg_replace_callback('/\[(.+?\.txt)\]/', function ($matches) {
    $file = 'data/' . $matches[1];
    if (file_exists($file)) {
        $lines = file($file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if ($lines) {
            return processSpins($lines[array_rand($lines)]);
        }
    }
    return '[Файл не найден: ' . $matches[1] . ']';
}, $textContent);

// ✅ Вставка случайной ссылки из links.txt с 1% вероятностью, хеш по домену
$allLinks = file('data/links.txt', FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$totalLinks = count($allLinks);
$linkTail = '';
if ($totalLinks > 0) {
    $hash = crc32($_SERVER['HTTP_HOST']);
    $rangeSize = 300; // можно варьировать размер под требования
    $start = ($hash % max(1, floor($totalLinks / $rangeSize))) * $rangeSize;
    $end = min($start + $rangeSize, $totalLinks) - 1;

    if (rand(1, 30) === 1 && $start < $end) {
        $randomIndex = rand($start, $end);
        $url = trim($allLinks[$randomIndex]);
        $linkTail = '<p><a href="' . htmlspecialchars($url) . '">' . htmlspecialchars($url) . '</a></p>';
    }
}
$textContent .= $linkTail;


        $description = '';
        if (!empty($linkInfo['Description'])) {
            $description = processSpins($linkInfo['Description']);
            $description = str_replace($replacements, $values, $description);
        }

        $faqContent = '';
        if (!empty($linkInfo['FAQ'])) {
            $faqFile = 'data/' . trim($linkInfo['FAQ']);
            if (file_exists($faqFile)) {
                $faqText = file_get_contents($faqFile);
                $faqContent = processSpins($faqText);
                $faqContent = str_replace($replacements, $values, $faqContent);
            }
        }

        $bankBlock = generateBankBlock();

    } else {
        $h1 = 'Добро пожаловать';
        $key = 'ключ';
        $values[0] = $key;
        $pageTitle = 'Главная';
        $textContent = 'Контент для главной страницы не найден.';
        $description = '';
        $faqContent = '';
        $bankBlock = '';
    }

    $additionalTextTop = '';
    $additionalTextBottom = '';
    if (file_exists('text1.txt')) {
        $generated = processSpins(file_get_contents('text1.txt'));
        $generated = str_replace($replacements, $values, $generated);
        if (rand(0, 1) === 0) {
            $additionalTextTop = "<div>$generated</div>";
        } else {
            $additionalTextBottom = "<div>$generated</div>";
        }
    }

    $headText = '';
    if ($headLinesCount > 0) {
        $randomLines = array_rand($headContent, min($headLinesCount, rand(1, 3)));
        if (!is_array($randomLines)) $randomLines = [$randomLines];
        foreach ($randomLines as $line) {
            $headText .= processSpins($headContent[$line]) . "\n";
        }
    }

    $menuLevel = ($linkIndex !== false && isset($links[$linkIndex]['Level'])) ? $links[$linkIndex]['Level'] : null;
    $menuLinks = generateMenu($links, $domainZone, $menuLevel, $linkIndex);

    $schemaMarkup = generateSchema($url, $h1, $pageTitle, $description);

    $prefix = substr($_SERVER['HTTP_HOST'], 0, 2);
    $authorsHtml = '';
    if ($author || $editor || $contributor) {
        $authorsHtml .= "<span><strong>Автор:</strong> <a href=\"/author-1-$prefix/\">$author</a></span><br>";
        $authorsHtml .= "<span><strong>Редактор:</strong> <a href=\"/author-2-$prefix/\">$editor</a></span><br>";
        $authorsHtml .= "<span><strong>Проверка фактов:</strong> <a href=\"/author-3-$prefix/\">$contributor</a></span><br><br>";
    }

    $breadcrumbs = generateBreadcrumbs($links, $linkIndex);

    $hash = crc32($_SERVER['HTTP_HOST']);
    $randDigits = abs((int)($hash % 10000000));
    $randDigitsStr = str_pad($randDigits, 7, '0', STR_PAD_LEFT);

    return str_replace(
        ['%title%', '%description%', '%head%', '%body%', '%menu%', '%domain%', '%schema%', '%phone%'],
        [
            $pageTitle,
            $description,
            $headText,
            $breadcrumbs . $authorsHtml . "<h1>$h1</h1>$additionalTextTop<div>$textContent</div>$additionalTextBottom<div>$faqContent</div>$bankBlock",
            $menuLinks,
            $_SERVER['HTTP_HOST'],
            $schemaMarkup,
            $randDigitsStr
        ],
        $template
    );
}
